#include "q3la.h"

int fLogMemory = 1;       // Perform logging (0=no; nonzero=yes)?

int cBlocksAllocated = 0;  // Count of blocks allocated.
int totalBytesAllocated = 0;
// User-defined operator new.
void *operator new( size_t stAllocateBlock )
{
    static fInOpNew = 0;    // Guard flag.

    if( fLogMemory && !fInOpNew )
    {
        fInOpNew = 1;
		totalBytesAllocated += stAllocateBlock;
		++cBlocksAllocated;
//		printf ("\nMemory block %i allocated for %i bytes (total: %i bytes)", cBlocksAllocated, stAllocateBlock, totalBytesAllocated);
        fInOpNew = 0;
    }

    return malloc( stAllocateBlock );
}
// User-defined operator delete.
void operator delete( void *pvMem )
{
    static fInOpDelete = 0;    // Guard flag.
    if( fLogMemory && !fInOpDelete )
    {
        fInOpDelete = 1;
//		printf ("\nMemory block %i deallocated", cBlocksAllocated);
		--cBlocksAllocated;
        fInOpDelete = 0;
    }

    free( pvMem );
}

